#include "g_local.h"
// Vital Statistics
class_info_t classinfo[] = {
	{	"No class",	"",	0,	0,	0,	},

	{
		"Thug",// Class Name
		"pipe, Pistol, Shotgun, Tommygun, SPistol, Shells, Bullets",// Items avail
		100,// Health
		50,// armor
		1,// Speed
	},
	{
		"Hitman",
		"pipe, FlameThrower, Heavy machinegun, Bazooka, Rockets, 308cal, Gas",
		125,
		100,
		0.75,
	},
#ifdef KINGPIN_ENABLED
	{
			"Kingpin",
			"pipe, crowbar, Pistol, Shotgun, Tommygun, FlameThrower, Heavy machinegun, Grenade Launcher, Bazooka, SPistol, Grenades, Shells, Bullets, Rockets, 308cal, Gas",
			100,
			50,
			1,
	},
#endif //KINGPIN_ENABLED

	{
		"Assassin",
		"Pistol, Heavy machinegun, Bazooka, Bullets, Rockets, 308cal",
		75,
		25,
		1.5
	},
	{
		"Gangster",
		"Pistol, Tommygun, Grenade Launcher , Bazooka, Bullets, 308cal, Rockets",
		125,
		25,
		1.25,

	},
	{
		"Hoodlum",
		"crowbar, Pistol, Tommygun, FlameThrower, SPistol, Bullets, Gas",
		125,
		100,
		0.75,
	},
};
class_info_t *FindClass (char *name)
{
	class_info_t *cl;
	int i;
	cl = classinfo;

	for (i=0; i < NUM_CLASSES; i++, cl++)
	{
		if (!cl->name)
			continue;

		if (Q_stricmp(cl->name, name) == 0)
			return cl;
	}
	return NULL;
}
qboolean ClassItemEnabled (edict_t *ent, edict_t *item)
{
	gclient_t	*client = ent->client;
	char		*str;

	str = strstr(kp_strlwr(client->resp.class_ptr->items),
			kp_strlwr(item->item->pickup_name));

	if (str == NULL)
		return false;
	else
		return true;
}
qboolean ClassItemEnabled2 (edict_t *ent, char *item)
{
	gclient_t	*client = ent->client;
	char		*str;

	str = strstr(kp_strlwr(client->resp.class_ptr->items),	kp_strlwr(item));

	if (str == NULL)
		return false;
	else
		return true;
}
qboolean CanBeKingpin (edict_t *ent)
{
	// Check this guys team to see if one exists
	 return false;
	// most efficient?
	// killed a few??
	return true;
}

void ClassSpeed (edict_t *ent, pmove_t *pm)
{
/*	int	speed;
	gclient_t *cl = ent->client;
	float speed_multiplier;// = cl->pers.class_ptr->speed;


	if (!class_speeds->value)
		return;

	// bugged out
	if (cl->resp.class_ptr)
		speed_multiplier = cl->resp.class_ptr->speed;
	else
		speed_multiplier = 1;

//	return;

	if (speed_multiplier > 1)
	{
		speed_multiplier *= 0.5;
	//	if (!highspeed->value)
			gi.Pmove (pm);
	}


	speed =  (int)(160 * speed_multiplier);

	if (((pm->cmd.forwardmove > 0)	||
		 (pm->cmd.sidemove > 0)		||
		 (pm->cmd.upmove > 0))		&& 
		 (ent->timestamp < level.time))
	{
		stuffcmd(ent, "cl_forwardspeed %i\0", speed); 
		stuffcmd(ent, "cl_sidespeed %i\0", speed); 
		stuffcmd(ent, "cl_upspeed %i\0", speed); 
		ent->timestamp = level.time + 1;// power
	}
*/
}

void Cmd_Class_f (edict_t *self)
{
	class_info_t *desired_class = NULL;

	if (Q_stricmp(gi.argv(1), "") == 0)
	{
		gi.cprintf(self, PRINT_HIGH, "You are currently %s\n", 
						self->client->resp.class_ptr->name);
		return;
	}

	desired_class = FindClass(gi.argv(1));

	if (desired_class == NULL)//; <- ARRRGG THAT LITTLE BASTARD SEMI-COLON I CANT BELIEVE I DIDNT SPOT IT
	{
		gi.cprintf(self, PRINT_HIGH, "No such class %s\n", gi.argv(1));
		return;
	}


	if (self->client->resp.class_ptr == desired_class)
	{
		gi.cprintf(self, PRINT_HIGH, "You are already %s\n",
			self->client->resp.class_ptr->name);
		return;
	}

	self->client->resp.class_ptr = desired_class;
	gi.cprintf(self, PRINT_HIGH, "You will be %s next time you respawn\n", 
		desired_class->name);

}
// TEST STUFF
static void Menu_Class_Select (edict_t *ent, entry_t *m)
{
	qboolean spawn = false;
//	Menu_Close(ent);

//	if (developer->value)
//		gi.dprintf("DEBUG: Set class %s\n", m->text);
	// is a spectator
	if (ent->movetype != MOVETYPE_WALK)
	{
		ent->movetype = MOVETYPE_WALK;
		ent->solid = SOLID_BBOX;
		ent->svflags &= ~SVF_NOCLIENT;

		Teamplay_ValidateSkin( ent );

		ent->health = 0;	// so we're not counted in spawn point checking
//		ent->client->resp.enterframe = level.framenum;
		InitClientResp( ent->client );
		spawn = true;
	}		
	
	switch (m->text[0])
	{
	case '1':
		ent->client->resp.class_ptr = FindClass("Thug");
		break;
	case '2':
		ent->client->resp.class_ptr = FindClass("Hitman");
		break;
	case '3':
		ent->client->resp.class_ptr = FindClass("Assassin");
		break;
	case '4':
		ent->client->resp.class_ptr = FindClass("Gangster");
		break;
	case '5':
		ent->client->resp.class_ptr = FindClass("Hoodlum");
		break;
/*	case '6':
		// Do kingpin check
		if (!CanBeKingpin(ent))
			return;
		ent->client->resp.class_ptr = FindClass("Kinpin");
		break;*/
	default:
		if (!developer->value)
			gi.dprintf("Unknown Class: %c\n", m->text[0] );
			//gi.error("Unknown Class\n");
		break;
	}

	if (developer->value)
		gi.dprintf("selected %s\n",ent->client->resp.class_ptr->name);

	// give/set health and armour
	if (spawn)
		PutClientInServer( ent );	// find a new spawn point

	SpeedCheck(ent);
	gi.bprintf(PRINT_HIGH, "%s has become a %s\n", ent->client->pers.netname, m->text+3 );
	Menu_Close(ent);
}
static void MenuClose (edict_t *ent, entry_t *m)
{
	Menu_Close(ent);
}
static void RandomClassSelect (edict_t *ent, entry_t *m)
{
	int i;
	if (developer->value)
		gi.dprintf("DEBUG: %s\n", m->text);

	i = 1 + rand() % NUM_CLASSES-1;
	ent->client->resp.class_ptr = &classinfo[i];

}
entry_t class_menu[] = {
/*	Text					Align			Function			Cost	Enabled*/
	{ NULL,					ALIGN_LEFT,		NULL,				0,		true },
	{ "*Select a Class",	ALIGN_LEFT,		NULL,				0,		true },
	{ NULL,					ALIGN_LEFT,		NULL,				0,		true },
	{ "1. Thug",			ALIGN_LEFT,		Menu_Class_Select,	0,		true },
	{ "2. Hitman",			ALIGN_LEFT,		Menu_Class_Select,	0,		true },
	{ "3. Assassin",		ALIGN_LEFT,		Menu_Class_Select,	0,		true },
	{ "4. Gangster",		ALIGN_LEFT,		Menu_Class_Select,	0,		true },
	{ "5. Hoodlum",			ALIGN_LEFT,		Menu_Class_Select,	0,		true },
//	{ "6. Kingpin",			ALIGN_LEFT,		Menu_Class_Select,	0,		true },
//	{ NULL,					ALIGN_LEFT,		NULL,				0,		true },
//	{ "7. Random Select",	ALIGN_LEFT,		RandomClassSelect,	0,		true },
//	{ NULL,					ALIGN_LEFT,		NULL,				0,		true },
//	{ "0. Exit",			ALIGN_LEFT,		MenuClose,		0,		true },

};

void Menu_Class (edict_t *ent)
{
	// Do kingpin check
	// if (!CanBeKingpin(ent))
	//	class_menu[7].enabled = false;

	Menu_Open(ent, class_menu, sizeof(class_menu)/sizeof(entry_t));
}
